/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.peripherals;

import com.hakimen.peripherals.blocks.tile_entities.GrinderEntity;
import com.hakimen.peripherals.registry.BlockRegister;
import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrinderPeripheral
implements IPeripheral,
IPeripheralProvider {
    private GrinderEntity tileEntity;
    private FakePlayer fakePlayer;

    @NotNull
    public String getType() {
        return "grinder";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other == this;
    }

    @LuaFunction(mainThread=true)
    public final void attack() {
        List entities = this.tileEntity.m_58904_().m_45933_(null, new AABB(this.tileEntity.m_58899_()).m_82377_(2.0, 2.0, 2.0));
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            this.fakePlayer.m_21008_(InteractionHand.MAIN_HAND, this.tileEntity.inventory.getStackInSlot(0));
            this.fakePlayer.m_5706_(entity);
            livingEntity.f_19802_ = 0;
            Item item = this.tileEntity.inventory.getStackInSlot(0).m_41720_();
            if (!(item instanceof SwordItem)) continue;
            SwordItem sword = (SwordItem)item;
            livingEntity.m_6469_(new DamageSources((RegistryAccess)RegistryAccess.f_243945_).m_269075_((Player)this.fakePlayer), sword.m_43299_());
        }
    }

    @LuaFunction(mainThread=true)
    public final MethodResult hasSword() {
        return MethodResult.of((Object)(this.tileEntity.inventory.getStackInSlot(0).m_41720_() instanceof SwordItem));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult pullSword(IComputerAccess computer, String from, int slot) {
        IPeripheral input = computer.getAvailablePeripheral(from);
        if (input == null) {
            return MethodResult.of((Object[])new Object[]{false, "the input " + from + " was not found"});
        }
        IItemHandler inputHandler = GrinderPeripheral.extractHandler(input.getTarget());
        if (slot < 0 || slot > inputHandler.getSlots()) {
            return MethodResult.of((Object[])new Object[]{false, "slot out of range"});
        }
        ItemStack stack = inputHandler.getStackInSlot(slot);
        if (stack.m_41720_() instanceof SwordItem) {
            if (!(this.tileEntity.inventory.getStackInSlot(0).m_41720_() instanceof SwordItem)) {
                this.tileEntity.inventory.setStackInSlot(0, stack.m_41777_());
                inputHandler.extractItem(slot, 1, false);
                return MethodResult.of((Object)true);
            }
            return MethodResult.of((Object[])new Object[]{false, "there is a sword in the grinder already"});
        }
        return MethodResult.of((Object)false);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult pushSword(IComputerAccess computer, String to) {
        IPeripheral input = computer.getAvailablePeripheral(to);
        if (input == null) {
            return MethodResult.of((Object[])new Object[]{false, "the output " + to + " was not found"});
        }
        IItemHandler inputHandler = GrinderPeripheral.extractHandler(input.getTarget());
        ItemStack stack = this.tileEntity.inventory.getStackInSlot(0).m_41777_();
        boolean sent = false;
        for (int i = 0; i < inputHandler.getSlots(); ++i) {
            if (!inputHandler.getStackInSlot(i).m_41619_()) continue;
            inputHandler.insertItem(i, stack, false);
            this.tileEntity.inventory.extractItem(0, 1, false);
            sent = true;
            break;
        }
        if (!sent) {
            return MethodResult.of((Object[])new Object[]{false, "target inventory is full"});
        }
        return MethodResult.of((Object)true);
    }

    @javax.annotation.Nullable
    private static IItemHandler extractHandler(@javax.annotation.Nullable Object object) {
        ICapabilityProvider provider;
        LazyOptional cap;
        BlockEntity blockEntity;
        if (object instanceof BlockEntity && (blockEntity = (BlockEntity)object).m_58901_()) {
            return null;
        }
        if (object instanceof ICapabilityProvider && (cap = (provider = (ICapabilityProvider)object).getCapability(ForgeCapabilities.ITEM_HANDLER)).isPresent()) {
            return (IItemHandler)cap.orElseThrow(NullPointerException::new);
        }
        if (object instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)object;
            return handler;
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            return new InvWrapper(container);
        }
        return null;
    }

    public LazyOptional<IPeripheral> getPeripheral(Level world, BlockPos pos, Direction side) {
        if (world.m_8055_(pos).m_60734_().equals(BlockRegister.grinder.get())) {
            GrinderPeripheral peripheral = new GrinderPeripheral();
            peripheral.tileEntity = (GrinderEntity)world.m_7702_(pos);
            peripheral.fakePlayer = new FakePlayer((ServerLevel)world, new GameProfile(UUID.randomUUID(), "Grinder"));
            return LazyOptional.of(() -> peripheral);
        }
        return LazyOptional.empty();
    }
}

