/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.peripherals;

import com.hakimen.peripherals.blocks.tile_entities.SpawnerInterfaceEntity;
import com.hakimen.peripherals.items.MobDataCardItem;
import com.hakimen.peripherals.registry.BlockRegister;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpawnerPeripheral
implements IPeripheral,
IPeripheralProvider {
    SpawnerInterfaceEntity tileEntity;
    long lastTime;

    @NotNull
    public String getType() {
        return "spawner_interface";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other == this;
    }

    @LuaFunction(mainThread=true)
    public final MethodResult changeSpawner(IComputerAccess computer, String inv, int slot, Optional<Boolean> force) {
        if (this.hasMultipleSpawners()) {
            return MethodResult.of((Object[])new Object[]{false, "more than one spawner present"});
        }
        if (!this.hasSpawner()) {
            return MethodResult.of((Object[])new Object[]{false, "no spawner present"});
        }
        --slot;
        IPeripheral peripheral = computer.getAvailablePeripheral(inv);
        if (inv == null) {
            return MethodResult.of((Object[])new Object[]{false, "the input " + inv + " was not found"});
        }
        IItemHandler handler = SpawnerPeripheral.extractHandler(peripheral.getTarget());
        if (slot < 0 || slot > handler.getSlots()) {
            return MethodResult.of((Object[])new Object[]{false, "slot out of range"});
        }
        ItemStack stack = handler.getStackInSlot(slot);
        if (stack.m_41782_() && stack.m_41720_() instanceof MobDataCardItem) {
            String previousMob = this.tileEntity.entity.m_187480_().m_128469_("SpawnData").m_128469_("entity").m_128461_("id");
            this.tileEntity.entity.m_59801_().m_253197_((EntityType)EntityType.m_20632_((String)stack.m_41783_().m_128461_("mob")).get(), this.tileEntity.m_58904_(), this.tileEntity.m_58904_().m_213780_(), this.tileEntity.m_58899_());
            if (force.isPresent() && force.get().booleanValue()) {
                stack.m_41783_().m_128473_("mob");
            } else {
                stack.m_41783_().m_128359_("mob", previousMob);
            }
            stack.m_41787_();
            CompoundTag tag = new CompoundTag();
            CompoundTag saved = this.tileEntity.entity.m_59801_().m_186381_(tag);
            this.tileEntity.entity.m_59801_().m_151328_(this.tileEntity.m_58904_(), this.tileEntity.m_58899_(), saved);
            this.tileEntity.m_6596_();
            this.tileEntity.entity.m_59801_().getSpawnerEntity();
            this.tileEntity.m_58904_().m_7260_(this.tileEntity.entity.m_58899_(), this.tileEntity.spawner, this.tileEntity.spawner, 3);
            return MethodResult.of((Object)true);
        }
        return MethodResult.of((Object)false);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getCurrentlySpawningMob() {
        if (this.hasMultipleSpawners()) {
            return MethodResult.of((Object[])new Object[]{false, "more than one spawner present"});
        }
        if (!this.hasSpawner()) {
            return MethodResult.of((Object[])new Object[]{false, "no spawner present"});
        }
        CompoundTag tag = new CompoundTag();
        tag = this.tileEntity.entity.m_59801_().m_186381_(tag);
        return MethodResult.of((Object)tag.m_128469_("SpawnData").m_128469_("entity").m_128461_("id"));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult captureSpawner(IComputerAccess computer, Optional<String> inv, Optional<Integer> slot) {
        if (this.hasMultipleSpawners()) {
            return MethodResult.of((Object[])new Object[]{false, "more than one spawner present"});
        }
        if (!this.hasSpawner()) {
            return MethodResult.of((Object[])new Object[]{false, "no spawner present"});
        }
        ItemStack spawnerBlock = new ItemStack((ItemLike)Items.f_42007_);
        CompoundTag tag = new CompoundTag();
        CompoundTag saved = this.tileEntity.entity.m_59801_().m_186381_(tag);
        if (this.lastTime + 50L >= System.currentTimeMillis()) {
            return MethodResult.of((Object)false);
        }
        if (inv.isPresent()) {
            IPeripheral peripheral = computer.getAvailablePeripheral(inv.get());
            if (inv.get() == null) {
                return MethodResult.of((Object[])new Object[]{false, "the input " + inv.get() + " was not found"});
            }
            IItemHandler handler = SpawnerPeripheral.extractHandler(peripheral.getTarget());
            if (slot.isPresent()) {
                if ((slot = Optional.of(slot.get() - 1)).get() < 0 || slot.get() > handler.getSlots()) {
                    return MethodResult.of((Object[])new Object[]{false, "slot out of range"});
                }
                ItemStack stack = handler.getStackInSlot(slot.get().intValue());
                if (stack.m_41720_() instanceof MobDataCardItem) {
                    stack.m_41784_().m_128359_("mob", saved.m_128469_("SpawnData").m_128469_("entity").m_128461_("id"));
                    stack.m_41714_((Component)Component.m_237115_((String)"item.peripherals.spawner_card").m_130946_(" (" + stack.m_41784_().m_128461_("mob") + ")"));
                    BlockPos blockPos = this.tileEntity.entity.m_58899_();
                    this.tileEntity.m_58904_().m_7967_((Entity)new ItemEntity(this.tileEntity.m_58904_(), (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), spawnerBlock));
                    this.tileEntity.m_58904_().m_46961_(blockPos, false);
                    this.lastTime = System.currentTimeMillis();
                    return MethodResult.of((Object)true);
                }
            }
        } else if (saved.m_128469_("SpawnData").m_128469_("entity").m_128461_("id").equals("minecraft:pig")) {
            BlockPos blockPos = this.tileEntity.m_58899_();
            this.tileEntity.m_58904_().m_7967_((Entity)new ItemEntity(this.tileEntity.m_58904_(), (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), spawnerBlock));
            this.tileEntity.m_58904_().m_46961_(blockPos, false);
            this.lastTime = System.currentTimeMillis();
            return MethodResult.of((Object)true);
        }
        return MethodResult.of((Object)false);
    }

    public boolean hasSpawner() {
        return this.tileEntity.entity != null;
    }

    public boolean hasMultipleSpawners() {
        return this.tileEntity.hasMultipleSpawners;
    }

    @javax.annotation.Nullable
    private static IItemHandler extractHandler(@javax.annotation.Nullable Object object) {
        ICapabilityProvider provider;
        LazyOptional cap;
        BlockEntity blockEntity;
        if (object instanceof BlockEntity && (blockEntity = (BlockEntity)object).m_58901_()) {
            return null;
        }
        if (object instanceof ICapabilityProvider && (cap = (provider = (ICapabilityProvider)object).getCapability(ForgeCapabilities.ITEM_HANDLER)).isPresent()) {
            return (IItemHandler)cap.orElseThrow(NullPointerException::new);
        }
        if (object instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)object;
            return handler;
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            return new InvWrapper(container);
        }
        return null;
    }

    public LazyOptional<IPeripheral> getPeripheral(Level world, BlockPos pos, Direction side) {
        if (world.m_8055_(pos).m_60734_().equals(BlockRegister.spawnerInterface.get())) {
            SpawnerPeripheral peripheral = new SpawnerPeripheral();
            peripheral.tileEntity = (SpawnerInterfaceEntity)world.m_7702_(pos);
            return LazyOptional.of(() -> peripheral);
        }
        return LazyOptional.empty();
    }
}

