/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.peripherals.turtle;

import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.core.util.ArgumentHelpers;
import dan200.computercraft.shared.platform.ContainerTransfer;
import dan200.computercraft.shared.platform.ForgeContainerTransfer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;

public class EnderBagPeripheral
implements IPeripheral {
    ITurtleAccess turtleAccess;
    TurtleSide side;

    public EnderBagPeripheral(ITurtleAccess turtleAccess, TurtleSide side) {
        this.turtleAccess = turtleAccess;
        this.side = side;
    }

    public String getType() {
        return "ender_bag";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other == this;
    }

    public PlayerEnderChestContainer getEnderInventory() {
        UUID ownerUUID = this.turtleAccess.getOwningPlayer().getId();
        Player player = this.turtleAccess.getLevel().m_46003_(ownerUUID);
        return player != null ? player.m_36327_() : null;
    }

    public Player getPlayer() {
        UUID ownerUUID = this.turtleAccess.getOwningPlayer().getId();
        Player player = this.turtleAccess.getLevel().m_46003_(ownerUUID);
        return player;
    }

    @LuaFunction(mainThread=true)
    public MethodResult list() {
        PlayerEnderChestContainer inventory = this.getEnderInventory();
        if (inventory == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player isn't present"});
        }
        HashMap<Integer, Map> result = new HashMap<Integer, Map>();
        int size = inventory.m_6643_();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            result.put(i + 1, VanillaDetailRegistries.ITEM_STACK.getBasicDetails((Object)stack));
        }
        return MethodResult.of(result);
    }

    @LuaFunction(mainThread=true)
    public MethodResult size() {
        PlayerEnderChestContainer inventory = this.getEnderInventory();
        if (inventory == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player isn't present"});
        }
        return MethodResult.of((Object)inventory.m_6643_());
    }

    @javax.annotation.Nullable
    @LuaFunction(mainThread=true)
    public MethodResult getItemDetail(int slot) throws LuaException {
        PlayerEnderChestContainer inventory = this.getEnderInventory();
        if (inventory == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player isn't present"});
        }
        ArgumentHelpers.assertBetween((int)slot, (int)1, (int)inventory.m_6643_(), (String)"Slot out of range (%s)");
        ItemStack stack = inventory.m_8020_(slot - 1);
        return MethodResult.of((Object)(stack.m_41619_() ? Boolean.valueOf(false) : VanillaDetailRegistries.ITEM_STACK.getDetails((Object)stack)));
    }

    @LuaFunction(mainThread=true)
    public MethodResult getItemLimit(int slot) throws LuaException {
        PlayerEnderChestContainer inventory = this.getEnderInventory();
        if (inventory == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player isn't present"});
        }
        ArgumentHelpers.assertBetween((int)slot, (int)1, (int)inventory.m_6643_(), (String)"Slot out of range (%s)");
        return MethodResult.of((Object)inventory.m_8020_(slot - 1).m_41741_());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @LuaFunction(mainThread=true)
    public MethodResult pushItems(IComputerAccess computer, int fromSlot, Optional<Integer> limit, Optional<Integer> toSlot) throws LuaException {
        PlayerEnderChestContainer inventory = this.getEnderInventory();
        if (inventory == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player isn't present"});
        }
        Container to = this.turtleAccess.getInventory();
        int actualLimit = limit.orElse(Integer.MAX_VALUE);
        ArgumentHelpers.assertBetween((int)fromSlot, (int)1, (int)inventory.m_6643_(), (String)"From slot out of range (%s)");
        if (toSlot.isPresent()) {
            ArgumentHelpers.assertBetween((int)toSlot.get(), (int)1, (int)to.m_6643_(), (String)"To slot out of range (%s)");
        }
        if (actualLimit <= 0) {
            return MethodResult.of((Object)0);
        }
        ItemStack og = inventory.m_8020_(fromSlot - 1).m_41777_();
        ItemStack extracted = inventory.m_7407_(fromSlot - 1, limit.orElse(1).intValue());
        if (this.canAddItem(to, extracted)) {
            if (toSlot.isPresent()) {
                ItemStack itemInSlot = inventory.m_8020_(toSlot.get() - 1);
                boolean canPlace = false;
                ItemStack placeStack = ItemStack.f_41583_;
                if (ItemStack.m_41656_((ItemStack)itemInSlot, (ItemStack)ItemStack.f_41583_)) {
                    canPlace = true;
                    placeStack = extracted;
                } else if (ItemStack.m_41656_((ItemStack)itemInSlot, (ItemStack)extracted) && itemInSlot.m_41613_() + extracted.m_41613_() <= itemInSlot.m_41741_()) {
                    canPlace = true;
                    placeStack = itemInSlot;
                    placeStack.m_41764_(itemInSlot.m_41613_() + extracted.m_41613_());
                }
                if (!canPlace) return MethodResult.of((Object[])new Object[]{false, "Couldn't move items to slot " + toSlot.get()});
                to.m_6836_(toSlot.get() - 1, placeStack);
                return MethodResult.of((Object)extracted.m_41613_());
            } else {
                boolean canPlace = false;
                ItemStack placeStack = ItemStack.f_41583_;
                for (int i = 0; i < to.m_6643_(); ++i) {
                    ItemStack itemInSlot = to.m_8020_(i);
                    if (itemInSlot.m_41619_()) {
                        canPlace = true;
                        placeStack = extracted;
                    } else if (ItemStack.m_41656_((ItemStack)itemInSlot, (ItemStack)extracted) && itemInSlot.m_41613_() + extracted.m_41613_() <= itemInSlot.m_41741_()) {
                        canPlace = true;
                        placeStack = itemInSlot;
                        placeStack.m_41764_(itemInSlot.m_41613_() + extracted.m_41613_());
                    }
                    if (!canPlace) continue;
                    if (placeStack == ItemStack.f_41583_) break;
                    to.m_6836_(i, placeStack);
                    break;
                }
                if (canPlace) return MethodResult.of((Object)extracted.m_41613_());
                inventory.m_19173_(extracted);
            }
            return MethodResult.of((Object)extracted.m_41613_());
        } else {
            inventory.m_6836_(fromSlot - 1, og);
            return MethodResult.of((Object[])new Object[]{false, "Turtle Inventory is full"});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @LuaFunction(mainThread=true)
    public MethodResult pullItems(IComputerAccess computer, int fromSlot, Optional<Integer> limit, Optional<Integer> toSlot) throws LuaException {
        PlayerEnderChestContainer inventory = this.getEnderInventory();
        if (inventory == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player isn't present"});
        }
        Container from = this.turtleAccess.getInventory();
        int actualLimit = limit.orElse(Integer.MAX_VALUE);
        ArgumentHelpers.assertBetween((int)fromSlot, (int)1, (int)from.m_6643_(), (String)"From slot out of range (%s)");
        if (toSlot.isPresent()) {
            ArgumentHelpers.assertBetween((int)toSlot.get(), (int)1, (int)inventory.m_6643_(), (String)"To slot out of range (%s)");
        }
        if (actualLimit <= 0) {
            return MethodResult.of((Object)0);
        }
        ItemStack og = from.m_8020_(fromSlot - 1).m_41777_();
        ItemStack extracted = from.m_7407_(fromSlot - 1, limit.orElse(1).intValue());
        int count = extracted.m_41613_();
        if (inventory.m_19183_(extracted)) {
            if (toSlot.isPresent()) {
                ItemStack itemInSlot = inventory.m_8020_(toSlot.get() - 1);
                boolean canPlace = false;
                ItemStack placeStack = ItemStack.f_41583_;
                if (ItemStack.m_41656_((ItemStack)itemInSlot, (ItemStack)ItemStack.f_41583_)) {
                    canPlace = true;
                    placeStack = extracted;
                } else if (ItemStack.m_41656_((ItemStack)itemInSlot, (ItemStack)extracted) && itemInSlot.m_41613_() + extracted.m_41613_() <= itemInSlot.m_41741_()) {
                    canPlace = true;
                    placeStack = itemInSlot;
                    placeStack.m_41764_(itemInSlot.m_41613_() + extracted.m_41613_());
                }
                if (!canPlace) return MethodResult.of((Object[])new Object[]{false, "Couldn't move items to slot " + toSlot.get()});
                inventory.m_6836_(toSlot.get() - 1, placeStack);
                return MethodResult.of((Object)count);
            } else {
                inventory.m_19173_(extracted);
            }
            return MethodResult.of((Object)count);
        } else {
            from.m_6836_(fromSlot - 1, og);
            return MethodResult.of((Object[])new Object[]{false, "Ender chest is full"});
        }
    }

    public boolean canAddItem(Container inventory, ItemStack p_19184_) {
        boolean flag = false;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemstack = inventory.m_8020_(i);
            if (!itemstack.m_41619_() && (!ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)p_19184_) || itemstack.m_41613_() >= itemstack.m_41741_())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    @javax.annotation.Nullable
    private IItemHandler extractHandler(@javax.annotation.Nullable Object object) {
        ICapabilityProvider provider;
        LazyOptional cap;
        BlockEntity blockEntity;
        if (object instanceof BlockEntity && (blockEntity = (BlockEntity)object).m_58901_()) {
            return null;
        }
        if (object instanceof ICapabilityProvider && (cap = (provider = (ICapabilityProvider)object).getCapability(ForgeCapabilities.ITEM_HANDLER)).isPresent()) {
            return (IItemHandler)cap.orElseThrow(NullPointerException::new);
        }
        if (object instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)object;
            return handler;
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            return new InvWrapper(container);
        }
        return null;
    }

    private static int moveItem(IItemHandler from, int fromSlot, IItemHandler to, int toSlot, int limit) {
        ForgeContainerTransfer fromWrapper = new ForgeContainerTransfer(from).singleSlot(fromSlot);
        ForgeContainerTransfer toWrapper = new ForgeContainerTransfer(to);
        if (toSlot >= 0) {
            toWrapper = toWrapper.singleSlot(toSlot);
        }
        return Math.max(0, fromWrapper.moveTo((ContainerTransfer)toWrapper, limit));
    }
}

