/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.peripherals.turtle;

import com.hakimen.peripherals.config.Config;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.turtle.TurtleUtil;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class MagnetTurtlePeripheral
implements IPeripheral {
    ITurtleAccess turtleAccess;
    TurtleSide side;

    public MagnetTurtlePeripheral(ITurtleAccess turtleAccess, TurtleSide side) {
        this.turtleAccess = turtleAccess;
        this.side = side;
    }

    public String getType() {
        return "magnet";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other instanceof MagnetTurtlePeripheral;
    }

    @LuaFunction(mainThread=true)
    public final MethodResult magnetize(int distance) {
        if (distance <= (Integer)Config.maxMagnetRange.get() && distance >= 1) {
            if (((Boolean)Config.magnetConsumesFuel.get()).booleanValue()) {
                this.turtleAccess.consumeFuel(distance * distance);
            }
            if (this.turtleAccess.getFuelLevel() >= distance * distance || !this.turtleAccess.isFuelNeeded()) {
                AABB range = new AABB(this.turtleAccess.getPosition()).m_82377_((double)distance, 2.0, (double)distance);
                List entityList = this.turtleAccess.getLevel().m_45933_(null, range);
                for (Entity entity : entityList) {
                    if (!(entity instanceof ItemEntity)) continue;
                    ItemEntity item = (ItemEntity)entity;
                    TurtleUtil.storeItemOrDrop((ITurtleAccess)this.turtleAccess, (ItemStack)item.m_32055_());
                    item.m_142687_(Entity.RemovalReason.DISCARDED);
                }
                this.turtleAccess.playAnimation(this.side == TurtleSide.LEFT ? TurtleAnimation.SWING_LEFT_TOOL : TurtleAnimation.SWING_RIGHT_TOOL);
                return MethodResult.of((Object)true);
            }
            return MethodResult.of((Object[])new Object[]{false, "Not enough fuel"});
        }
        return MethodResult.of((Object[])new Object[]{false, "Invalid distance"});
    }
}

