/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration.computers;

import com.brandon3055.brandonscore.api.power.IOInfo;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyPylon;
import com.brandon3055.draconicevolution.integration.computers.CCOCIntegration;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class PeripheralEnergyPylon
implements IPeripheral,
ICapabilityProvider {
    TileEnergyPylon tile;
    private LazyOptional<IPeripheral> self;

    public PeripheralEnergyPylon(TileEnergyPylon tile) {
        this.tile = tile;
    }

    public String getType() {
        return "draconic_rf_storage";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(IPeripheral other) {
        if (!(other instanceof PeripheralEnergyPylon)) return false;
        PeripheralEnergyPylon o = (PeripheralEnergyPylon)other;
        if (this.tile != o.tile) return false;
        return true;
    }

    @LuaFunction(mainThread=true)
    public final long getEnergyStored() {
        return this.tile.opAdapter.getOPStored();
    }

    @LuaFunction(mainThread=true)
    public final long getMaxEnergyStored() {
        return this.tile.opAdapter.getMaxOPStored();
    }

    @LuaFunction(mainThread=true)
    public final Map<Object, Object> getEnergyStoredInNotation() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        String[] split = this.tile.getCore().energy.getScientific().split("E", 2);
        map.put("coefficient", Double.parseDouble(split[0]));
        map.put("exponent", Integer.parseInt(split[1]));
        return map;
    }

    @LuaFunction(mainThread=true)
    public final Map<Object, Object> getMaxEnergyStoredInNotation() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        long maxEnergy = this.tile.opAdapter.getMaxOPStored();
        String[] split = new DecimalFormat("0.######E0", DecimalFormatSymbols.getInstance(Locale.ROOT)).format(maxEnergy).split("E", 2);
        map.put("coefficient", Double.parseDouble(maxEnergy == Long.MAX_VALUE ? "-1" : split[0]));
        map.put("exponent", Integer.parseInt(maxEnergy == Long.MAX_VALUE ? "-1" : split[1]));
        return map;
    }

    @LuaFunction(mainThread=true)
    public final long getTransferPerTick() {
        if (this.tile.coreOffset.isNull() || this.tile.getCore() == null) {
            return 0L;
        }
        IOInfo io = this.tile.getCore().energy.getIOInfo();
        return io == null ? 0L : io.currentInput() - io.currentOutput();
    }

    @LuaFunction(mainThread=true)
    public final long getInputPerTick() {
        if (this.tile.coreOffset.isNull() || this.tile.getCore() == null) {
            return 0L;
        }
        IOInfo io = this.tile.getCore().energy.getIOInfo();
        return io == null ? 0L : io.currentInput();
    }

    @LuaFunction(mainThread=true)
    public final long getOutputPerTick() {
        if (this.tile.coreOffset.isNull() || this.tile.getCore() == null) {
            return 0L;
        }
        IOInfo io = this.tile.getCore().energy.getIOInfo();
        return io == null ? 0L : io.currentOutput();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (CCOCIntegration.isPeripheral(cap)) {
            if (this.self == null) {
                this.self = LazyOptional.of(() -> this);
            }
            return this.self.cast();
        }
        return LazyOptional.empty();
    }

    public void invalidate() {
        if (this.self == null) {
            return;
        }
        this.self.invalidate();
        this.self = null;
    }
}

