/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration.jei;

import codechicken.lib.gui.modular.ModularGui;
import codechicken.lib.gui.modular.elements.GuiItemStack;
import codechicken.lib.gui.modular.elements.GuiProgressIcon;
import codechicken.lib.gui.modular.elements.GuiTexture;
import com.brandon3055.brandonscore.integration.ModularGuiProperties;
import com.brandon3055.draconicevolution.api.DraconicAPI;
import com.brandon3055.draconicevolution.api.crafting.IFusionRecipe;
import com.brandon3055.draconicevolution.client.gui.DraconiumChestGui;
import com.brandon3055.draconicevolution.client.gui.EnergyCoreGui;
import com.brandon3055.draconicevolution.client.gui.FusionCraftingCoreGui;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.ConfigurableItemGui;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.integration.jei.FusionRecipeCategory;
import com.brandon3055.draconicevolution.integration.jei.FusionRecipeTransferHelper;
import com.brandon3055.draconicevolution.inventory.DraconiumChestMenu;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class DEJEIPlugin
implements IModPlugin {
    public static IJeiHelpers jeiHelpers = null;
    public static IJeiRuntime jeiRuntime = null;
    public static RecipeType<IFusionRecipe> FUSION_RECIPE_TYPE = RecipeType.create((String)"draconicevolution", (String)"fusion_crafting", IFusionRecipe.class);
    @Nullable
    private FusionRecipeCategory fusionRecipeCategory;

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiScreenHandler(ConfigurableItemGui.Screen.class, gui -> null);
        registration.addGuiScreenHandler(EnergyCoreGui.Screen.class, gui -> EnergyCoreGui.Screen.hideJEI.get() ? null : ModularGuiProperties.create((ModularGui)gui.getModularGui()));
        registration.addGuiContainerHandler(DraconiumChestGui.Screen.class, (IGuiContainerHandler)new IGuiContainerHandler<DraconiumChestGui.Screen>(){

            public Collection<IGuiClickableArea> getGuiClickableAreas(DraconiumChestGui.Screen screen, double mouseX, double mouseY) {
                DraconiumChestGui gui = (DraconiumChestGui)screen.getModularGui().getProvider();
                if (gui.colourDialog != null && !gui.colourDialog.isRemoved()) {
                    return Collections.emptyList();
                }
                GuiTexture craftIcon = gui.craftIcon;
                GuiProgressIcon smeltArrow = gui.furnaceProgress;
                IGuiClickableArea craftingArea = IGuiClickableArea.createBasic((int)((int)craftIcon.xMin() - (int)screen.getModularGui().getRoot().xMin()), (int)((int)craftIcon.yMin() - (int)screen.getModularGui().getRoot().yMin()), (int)((int)craftIcon.xSize()), (int)((int)craftIcon.ySize()), (RecipeType[])new RecipeType[]{RecipeTypes.CRAFTING});
                IGuiClickableArea smeltingArea = IGuiClickableArea.createBasic((int)((int)smeltArrow.xMin() - (int)screen.getModularGui().getRoot().xMin()), (int)((int)smeltArrow.yMin() - (int)screen.getModularGui().getRoot().yMin()), (int)((int)smeltArrow.xSize()), (int)((int)smeltArrow.ySize()), (RecipeType[])new RecipeType[]{RecipeTypes.SMELTING});
                return Lists.newArrayList((Object[])new IGuiClickableArea[]{craftingArea, smeltingArea});
            }
        });
        registration.addGuiContainerHandler(FusionCraftingCoreGui.Screen.class, (IGuiContainerHandler)new IGuiContainerHandler<FusionCraftingCoreGui.Screen>(){

            public Collection<IGuiClickableArea> getGuiClickableAreas(FusionCraftingCoreGui.Screen screen, double mouseX, double mouseY) {
                FusionCraftingCoreGui gui = (FusionCraftingCoreGui)screen.getModularGui().getProvider();
                if (gui.hideRecipes.get().booleanValue()) {
                    return Collections.emptyList();
                }
                GuiItemStack craftIcon = gui.stackIcon;
                IGuiClickableArea craftingArea = IGuiClickableArea.createBasic((int)((int)craftIcon.xMin() - (int)screen.getModularGui().getRoot().xMin()), (int)((int)craftIcon.yMin() - (int)screen.getModularGui().getRoot().yMin()), (int)((int)craftIcon.xSize()), (int)((int)craftIcon.ySize()), (RecipeType[])new RecipeType[]{FUSION_RECIPE_TYPE});
                return Collections.singletonList(craftingArea);
            }
        });
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[1];
        this.fusionRecipeCategory = new FusionRecipeCategory(guiHelper);
        iRecipeCategoryArray[0] = this.fusionRecipeCategory;
        registration.addRecipeCategories(iRecipeCategoryArray);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        jeiHelpers = registration.getJeiHelpers();
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        registration.addRecipes(FUSION_RECIPE_TYPE, world.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)DraconicAPI.FUSION_RECIPE_TYPE.get()));
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IRecipeTransferHandlerHelper transferHelper = registration.getTransferHelper();
        IStackHelper stackHelper = jeiHelpers.getStackHelper();
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new FusionRecipeTransferHelper(stackHelper, transferHelper), FUSION_RECIPE_TYPE);
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new IRecipeTransferInfo<DraconiumChestMenu, CraftingRecipe>(){

            public Class<DraconiumChestMenu> getContainerClass() {
                return DraconiumChestMenu.class;
            }

            public RecipeType<CraftingRecipe> getRecipeType() {
                return RecipeTypes.CRAFTING;
            }

            public Optional<MenuType<DraconiumChestMenu>> getMenuType() {
                return Optional.of((MenuType)DEContent.MENU_DRACONIUM_CHEST.get());
            }

            public boolean canHandle(DraconiumChestMenu container, CraftingRecipe recipe) {
                return true;
            }

            public List<Slot> getRecipeSlots(DraconiumChestMenu container, CraftingRecipe recipe) {
                return container.craftIn.slots().stream().map(e -> e).toList();
            }

            public List<Slot> getInventorySlots(DraconiumChestMenu container, CraftingRecipe recipe) {
                return Stream.of(container.chestInv.slots(), container.main.slots(), container.hotBar.slots()).flatMap(Collection::stream).collect(Collectors.toList());
            }
        });
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new IRecipeTransferInfo<DraconiumChestMenu, SmeltingRecipe>(){

            public Class<DraconiumChestMenu> getContainerClass() {
                return DraconiumChestMenu.class;
            }

            public RecipeType<SmeltingRecipe> getRecipeType() {
                return RecipeTypes.SMELTING;
            }

            public Optional<MenuType<DraconiumChestMenu>> getMenuType() {
                return Optional.of((MenuType)DEContent.MENU_DRACONIUM_CHEST.get());
            }

            public boolean canHandle(DraconiumChestMenu container, SmeltingRecipe recipe) {
                return true;
            }

            public List<Slot> getRecipeSlots(DraconiumChestMenu container, SmeltingRecipe recipe) {
                return container.furnaceInputs.slots().stream().map(e -> e).toList();
            }

            public List<Slot> getInventorySlots(DraconiumChestMenu container, SmeltingRecipe recipe) {
                return Stream.of(container.chestInv.slots(), container.main.slots(), container.hotBar.slots()).flatMap(Collection::stream).collect(Collectors.toList());
            }
        });
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)DEContent.CRAFTING_CORE.get()), new RecipeType[]{FUSION_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)DEContent.DRACONIUM_CHEST.get()), new RecipeType[]{RecipeTypes.CRAFTING, RecipeTypes.SMELTING});
    }

    public void onRuntimeAvailable(IJeiRuntime iJeiRuntime) {
        jeiRuntime = iJeiRuntime;
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("draconicevolution", "jei_plugin");
    }
}

