/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.world.noise;

import com.yungnickyoung.minecraft.yungscavebiomes.world.NoiseSamplerBiomeHolder;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.LinearCongruentialGenerator;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.levelgen.DensityFunction;

public class MarbleCavesInterpolationSlideDensityFunction
implements DensityFunction {
    private static final double SQRT3 = Math.sqrt(3.0);
    private static final int SEARCH_RADIUS_INT = Mth.m_14165_((double)(SQRT3 * 4.0));
    public static final int BLOCK_XYZ_OFFSET = 2;
    private static final int FIDDLE_HASH_BIT_START = 24;
    private static final int FIDDLE_HASH_BIT_COUNT = 10;
    private static final int FIDDLE_HASH_BIT_SHIFTED = 1024;
    private static final int FIDDLE_HASH_BIT_MASK = 1023;
    private static final double FIDDLE_MAGNITUDE = 1.0;
    private final NoiseSamplerBiomeHolder holder;
    private final long biomeZoomSeed;

    public MarbleCavesInterpolationSlideDensityFunction(NoiseSamplerBiomeHolder holder) {
        this.holder = holder;
        this.biomeZoomSeed = BiomeManager.m_47877_((long)holder.getWorldSeed());
    }

    public double m_207386_(DensityFunction.FunctionContext context) {
        BiomeSource source = this.holder.getBiomeSource();
        Registry<Biome> biomes = this.holder.getBiomeRegistry();
        if (source != null && biomes != null) {
            int offsetX = context.m_207115_() - 2;
            int offsetY = context.m_207114_() - 2;
            int offsetZ = context.m_207113_() - 2;
            int xStart = offsetX - SEARCH_RADIUS_INT >> 2;
            int yStart = offsetY - SEARCH_RADIUS_INT >> 2;
            int zStart = offsetZ - SEARCH_RADIUS_INT >> 2;
            int xEnd = offsetX + SEARCH_RADIUS_INT >> 2;
            int yEnd = offsetY + SEARCH_RADIUS_INT >> 2;
            int zEnd = offsetZ + SEARCH_RADIUS_INT >> 2;
            int xCount = xEnd - xStart + 1;
            int yCount = yEnd - yStart + 1;
            int zCount = zEnd - zStart + 1;
            double xDelta = (double)(offsetX - (xStart << 2)) * 0.25;
            double yDelta = (double)(offsetY - (yStart << 2)) * 0.25;
            double zDelta = (double)(offsetZ - (zStart << 2)) * 0.25;
            double totalWeight = 0.0;
            double marbleWeight = 0.0;
            int cz = 0;
            int cy = 0;
            int cx = 0;
            while (true) {
                double fiddledDistanceSquared;
                if ((fiddledDistanceSquared = MarbleCavesInterpolationSlideDensityFunction.getFiddledDistance(this.biomeZoomSeed, cx + xStart, cy + yStart, cz + zStart, xDelta - (double)cx, yDelta - (double)cy, zDelta - (double)cz)) < 3.0) {
                    double falloff = 3.0 - fiddledDistanceSquared;
                    falloff *= falloff * falloff;
                    Holder biomeHolderHere = source.m_203407_(cx + xStart, cy + yStart, cz + zStart, this.holder.getClimateSampler());
                    totalWeight += falloff;
                    if (this.shouldSolidifyForMarbleCaves((Holder<Biome>)biomeHolderHere, cy + yStart)) {
                        marbleWeight += falloff;
                    }
                }
                if (++cz < zCount) continue;
                cz = 0;
                if (++cy < yCount) continue;
                cy = 0;
                if (++cx >= xCount) break;
            }
            return marbleWeight / totalWeight;
        }
        return 0.0;
    }

    private boolean shouldSolidifyForMarbleCaves(Holder<Biome> biome, int quartY) {
        return quartY <= 0;
    }

    private static double getFiddledDistance(long seed, int quartX, int quartY, int quartZ, double dx, double dy, double dz) {
        long hash = LinearCongruentialGenerator.m_13972_((long)seed, (long)quartX);
        hash = LinearCongruentialGenerator.m_13972_((long)hash, (long)quartY);
        hash = LinearCongruentialGenerator.m_13972_((long)hash, (long)quartZ);
        hash = LinearCongruentialGenerator.m_13972_((long)hash, (long)quartX);
        hash = LinearCongruentialGenerator.m_13972_((long)hash, (long)quartY);
        hash = LinearCongruentialGenerator.m_13972_((long)hash, (long)quartZ);
        double jz = MarbleCavesInterpolationSlideDensityFunction.getFiddle(hash);
        hash = LinearCongruentialGenerator.m_13972_((long)hash, (long)seed);
        double jy = MarbleCavesInterpolationSlideDensityFunction.getFiddle(hash);
        hash = LinearCongruentialGenerator.m_13972_((long)hash, (long)seed);
        double jx = MarbleCavesInterpolationSlideDensityFunction.getFiddle(hash);
        return Mth.m_144952_((double)(dz + jz)) + Mth.m_144952_((double)(dy + jy)) + Mth.m_144952_((double)(dx + jx));
    }

    private static double getFiddle(long hash) {
        long hashBits = hash >> 24 & 0x3FFL;
        return (double)hashBits * 9.765625E-4 - 0.5;
    }

    public void m_207362_(double[] doubles, DensityFunction.ContextProvider contextProvider) {
        contextProvider.m_207207_(doubles, (DensityFunction)this);
    }

    public DensityFunction m_207456_(DensityFunction.Visitor visitor) {
        return visitor.m_214017_((DensityFunction)new MarbleCavesInterpolationSlideDensityFunction(this.holder));
    }

    public double m_207402_() {
        return 0.0;
    }

    public double m_207401_() {
        return 1.0;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return null;
    }
}

