/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class ManagedVector3i
extends AbstractManagedData<Vec3i> {
    private Vec3i value;
    private Vec3i defaultValue;
    protected Function<Vec3i, Vec3i> validator = null;

    public ManagedVector3i(String name, @Nullable Vec3i defaultValue, DataFlags ... flags) {
        super(name, flags);
        this.value = defaultValue;
        this.defaultValue = defaultValue == null ? null : new Vec3i(defaultValue.m_123341_(), defaultValue.m_123342_(), defaultValue.m_123343_());
    }

    public ManagedVector3i(String name, DataFlags ... flags) {
        this(name, new Vec3i(0, 0, 0), flags);
    }

    public Vec3i set(Vec3i value) {
        if (!Objects.equals(this.value, value)) {
            boolean set = true;
            Vec3i prev = this.value;
            this.value = value;
            if (this.dataManager.isClientSide() && this.flags.allowClientControl) {
                this.dataManager.sendToServer(this);
                set = this.ccscsFlag;
            }
            if (set) {
                this.markDirty();
                this.notifyListeners(value);
            } else {
                this.value = prev;
            }
        }
        return this.value;
    }

    @Nullable
    public Vec3i get() {
        return this.value;
    }

    public ManagedVector3i setValidator(Function<Vec3i, Vec3i> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void validate() {
        if (this.validator != null) {
            this.value = this.validator.apply(this.value);
        }
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writeBoolean(this.value != null);
        if (this.value != null) {
            output.writeVec3i(this.value);
        }
    }

    @Override
    public void fromBytes(MCDataInput input) {
        this.value = input.readBoolean() ? input.readVec3i() : null;
        this.notifyListeners(this.value);
    }

    @Override
    public void toNBT(CompoundTag compound) {
        CompoundTag nbt = new CompoundTag();
        if (this.value == null) {
            nbt.m_128379_("null", true);
        } else {
            nbt.m_128405_("x", this.value.m_123341_());
            nbt.m_128405_("y", this.value.m_123342_());
            nbt.m_128405_("z", this.value.m_123343_());
        }
        compound.m_128365_(this.name, (Tag)nbt);
    }

    @Override
    public void fromNBT(CompoundTag compound) {
        CompoundTag nbt;
        this.value = !compound.m_128425_(this.name, 10) ? (this.defaultValue == null ? null : new Vec3i(this.defaultValue.m_123341_(), this.defaultValue.m_123342_(), this.defaultValue.m_123343_())) : ((nbt = compound.m_128469_(this.name)).m_128441_("null") ? null : new Vec3i(nbt.m_128451_("x"), nbt.m_128451_("y"), nbt.m_128451_("z")));
        this.notifyListeners(this.value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getName() + "=" + this.value + "]";
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean notNull() {
        return this.value != null;
    }
}

