/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.scene;

import appeng.client.guidebook.scene.CameraSettings;
import appeng.client.guidebook.scene.GuidebookLightmap;
import appeng.client.guidebook.scene.LiquidVertexConsumer;
import appeng.client.guidebook.scene.SodiumCompat;
import appeng.client.guidebook.scene.annotation.InWorldAnnotation;
import appeng.client.guidebook.scene.annotation.InWorldAnnotationRenderer;
import appeng.client.guidebook.scene.level.GuidebookLevel;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class GuidebookLevelRenderer {
    private static GuidebookLevelRenderer instance;
    private final GuidebookLightmap lightmap = new GuidebookLightmap();

    public static GuidebookLevelRenderer getInstance() {
        RenderSystem.assertOnRenderThread();
        if (instance == null) {
            instance = new GuidebookLevelRenderer();
        }
        return instance;
    }

    public void render(GuidebookLevel level, CameraSettings cameraSettings, Collection<InWorldAnnotation> annotations) {
        this.lightmap.update(level);
        RenderSystem.clear((int)256, (boolean)Minecraft.f_91002_);
        RenderSystem.setShaderGameTime((long)System.currentTimeMillis(), (float)0.0f);
        MultiBufferSource.BufferSource buffers = Minecraft.m_91087_().m_91269_().m_110104_();
        this.render(level, cameraSettings, buffers, annotations);
        RenderSystem.clear((int)256, (boolean)Minecraft.f_91002_);
    }

    public void render(GuidebookLevel level, CameraSettings cameraSettings, MultiBufferSource.BufferSource buffers, Collection<InWorldAnnotation> annotations) {
        this.lightmap.update(level);
        LevelLightEngine lightEngine = level.m_5518_();
        while (lightEngine.m_75808_()) {
            lightEngine.m_9323_();
        }
        Matrix4f projectionMatrix = cameraSettings.getProjectionMatrix();
        Matrix4f viewMatrix = cameraSettings.getViewMatrix();
        RenderSystem.setShaderFogColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
        RenderSystem.setShaderFogStart((float)0.0f);
        RenderSystem.setShaderFogEnd((float)1000.0f);
        RenderSystem.setShaderFogShape((FogShape)FogShape.SPHERE);
        PoseStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.m_85836_();
        modelViewStack.m_166856_();
        modelViewStack.m_252931_(viewMatrix);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrix, (VertexSorting)VertexSorting.f_276633_);
        Vector4f lightDirection = new Vector4f(0.16666667f, 0.35f, 1.0f, 0.0f);
        Matrix4f lightTransform = new Matrix4f((Matrix4fc)viewMatrix);
        lightTransform.invert();
        lightTransform.transform(lightDirection);
        Vector3f transformedLightDirection = new Vector3f(lightDirection.x, lightDirection.y, lightDirection.z);
        RenderSystem.setShaderLights((Vector3f)transformedLightDirection, (Vector3f)transformedLightDirection);
        this.renderContent(level, buffers);
        InWorldAnnotationRenderer.render(buffers, annotations);
        modelViewStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.restoreProjectionMatrix();
        Lighting.m_84931_();
    }

    public void renderContent(GuidebookLevel level, MultiBufferSource.BufferSource buffers) {
        RenderSystem.runAsFancy(() -> {
            this.renderBlocks(level, (MultiBufferSource)buffers, false);
            this.renderBlockEntities(level, (MultiBufferSource)buffers);
            buffers.m_109912_(RenderType.m_110446_((ResourceLocation)TextureAtlas.f_118259_));
            buffers.m_109912_(RenderType.m_110452_((ResourceLocation)TextureAtlas.f_118259_));
            buffers.m_109912_(RenderType.m_110458_((ResourceLocation)TextureAtlas.f_118259_));
            buffers.m_109912_(RenderType.m_110476_((ResourceLocation)TextureAtlas.f_118259_));
            for (RenderType layer : RenderType.m_110506_()) {
                if (layer == RenderType.m_110466_()) continue;
                buffers.m_109912_(layer);
            }
            buffers.m_109912_(RenderType.m_110451_());
            buffers.m_109912_(RenderType.m_173239_());
            buffers.m_109912_(RenderType.m_173242_());
            buffers.m_109912_(Sheets.m_110789_());
            buffers.m_109912_(Sheets.m_110790_());
            buffers.m_109912_(Sheets.m_110785_());
            buffers.m_109912_(Sheets.m_110786_());
            buffers.m_109912_(Sheets.m_110787_());
            buffers.m_109912_(Sheets.m_246640_());
            buffers.m_109912_(Sheets.m_110788_());
            buffers.m_173043_();
            this.renderBlocks(level, (MultiBufferSource)buffers, true);
            buffers.m_109912_(RenderType.m_110466_());
        });
    }

    private void renderBlocks(GuidebookLevel level, MultiBufferSource buffers, boolean translucent) {
        RandomSource randomSource = level.f_46441_;
        BlockRenderDispatcher blockRenderDispatcher = Minecraft.m_91087_().m_91289_();
        PoseStack poseStack = new PoseStack();
        level.getFilledBlocks().forEach(pos -> {
            RenderType renderType;
            BlockState blockState = level.m_8055_((BlockPos)pos);
            FluidState fluidState = blockState.m_60819_();
            if (!fluidState.m_76178_() && ((renderType = ItemBlockRenderTypes.m_109287_((FluidState)fluidState)) != RenderType.m_110466_() || translucent)) {
                VertexConsumer bufferBuilder = buffers.m_6299_(renderType);
                SectionPos sectionPos = SectionPos.m_123199_((BlockPos)pos);
                LiquidVertexConsumer liquidVertexConsumer = new LiquidVertexConsumer(bufferBuilder, sectionPos);
                blockRenderDispatcher.m_234363_(pos, (BlockAndTintGetter)level, (VertexConsumer)liquidVertexConsumer, blockState, fluidState);
                GuidebookLevelRenderer.markFluidSpritesActive(fluidState);
            }
            if (blockState.m_60799_() != RenderShape.INVISIBLE) {
                BlockEntity be = level.m_7702_((BlockPos)pos);
                ModelData modelData = ModelData.EMPTY;
                if (be != null) {
                    modelData = be.getModelData();
                }
                BakedModel model = blockRenderDispatcher.m_110910_(blockState);
                modelData = model.getModelData((BlockAndTintGetter)level, pos, blockState, modelData);
                ChunkRenderTypeSet renderTypes = model.getRenderTypes(blockState, randomSource, modelData);
                for (RenderType renderType2 : renderTypes) {
                    if (renderType2 == RenderType.m_110466_() && !translucent) continue;
                    VertexConsumer bufferBuilder = buffers.m_6299_(renderType2);
                    poseStack.m_85836_();
                    poseStack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
                    blockRenderDispatcher.renderBatched(blockState, pos, (BlockAndTintGetter)level, poseStack, bufferBuilder, true, randomSource, modelData, renderType2);
                    poseStack.m_85849_();
                }
            }
        });
    }

    private void renderBlockEntities(GuidebookLevel level, MultiBufferSource buffers) {
        PoseStack poseStack = new PoseStack();
        level.getFilledBlocks().forEach(pos -> {
            BlockEntity blockEntity;
            BlockState blockState = level.m_8055_((BlockPos)pos);
            if (blockState.m_155947_() && (blockEntity = level.m_7702_((BlockPos)pos)) != null) {
                this.handleBlockEntity(poseStack, blockEntity, buffers);
            }
        });
    }

    private static void markFluidSpritesActive(FluidState fluidState) {
        IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((FluidState)fluidState);
        TextureAtlasSprite sprite1 = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(props.getStillTexture());
        SodiumCompat.markSpriteActive(sprite1);
        TextureAtlasSprite sprite2 = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(props.getFlowingTexture());
        SodiumCompat.markSpriteActive(sprite2);
    }

    private <E extends BlockEntity> void handleBlockEntity(PoseStack stack, E blockEntity, MultiBufferSource buffers) {
        BlockEntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_167982_();
        BlockEntityRenderer renderer = dispatcher.m_112265_(blockEntity);
        if (renderer != null) {
            BlockPos pos = blockEntity.m_58899_();
            stack.m_85836_();
            stack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
            int packedLight = LevelRenderer.m_109541_((BlockAndTintGetter)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_());
            renderer.m_6922_(blockEntity, 0.0f, stack, buffers, packedLight, OverlayTexture.f_118083_);
            stack.m_85849_();
        }
    }
}

