/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import mcjty.lib.container.GenericContainer;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SafeClientTools;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;

public record PacketDataFromServer(BlockPos pos, String command, TypedMap result) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("mcjtylib", "datafromserver");

    @Override
    public void write(FriendlyByteBuf buf) {
        if (this.pos != null) {
            buf.writeBoolean(true);
            buf.m_130064_(this.pos);
        } else {
            buf.writeBoolean(false);
        }
        buf.m_130070_(this.command);
        buf.writeBoolean(this.result != null);
        if (this.result != null) {
            TypedMapTools.writeArguments(buf, this.result);
        }
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    public static PacketDataFromServer create(FriendlyByteBuf buf) {
        BlockPos pos = buf.readBoolean() ? buf.m_130135_() : null;
        String command = buf.m_130136_(Short.MAX_VALUE);
        TypedMap result = buf.readBoolean() ? TypedMapTools.readArguments(buf) : null;
        return new PacketDataFromServer(pos, command, result);
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            GenericTileEntity generic;
            BlockEntity te;
            if (this.pos == null) {
                GenericContainer container = PacketDataFromServer.getOpenContainer();
                if (container == null) {
                    Logging.log("Container is missing!");
                    return;
                }
                te = container.getTe();
            } else {
                te = SafeClientTools.getClientWorld().m_7702_(this.pos);
            }
            if (te instanceof GenericTileEntity && (generic = (GenericTileEntity)te).executeClientCommand(this.command, SafeClientTools.getClientPlayer(), this.result)) {
                return;
            }
            Logging.log("Command " + this.command + " was not handled!");
        });
    }

    private static GenericContainer getOpenContainer() {
        AbstractContainerMenu container = SafeClientTools.getClientPlayer().f_36096_;
        if (container instanceof GenericContainer) {
            return (GenericContainer)container;
        }
        return null;
    }
}

