/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.lib.McJtyLib;
import mcjty.lib.varia.LevelTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.ITeleporter;

public class TeleportationTools {
    public static void teleport(Player player, ResourceKey<Level> dimension, double destX, double destY, double destZ, @Nullable Direction direction) {
        ResourceKey oldId = player.m_20193_().m_46472_();
        float rotationYaw = player.m_146908_();
        float rotationPitch = player.m_146909_();
        if (!oldId.equals(dimension)) {
            TeleportationTools.teleportToDimension(player, dimension, destX, destY, destZ);
        }
        if (direction != null) {
            TeleportationTools.fixOrientation((Entity)player, destX, destY, destZ, direction);
        } else {
            player.m_146922_(rotationYaw);
            player.m_146926_(rotationPitch);
        }
        player.m_6021_(destX, destY, destZ);
    }

    public static void teleportToDimension(Player player, ResourceKey<Level> dimension, final double x, final double y, final double z) {
        ServerLevel world = LevelTools.getLevel(player.m_20193_(), dimension);
        if (world == null) {
            McJtyLib.setup.getLogger().error("Something went wrong teleporting to dimension " + dimension.m_135782_().m_135815_());
            return;
        }
        player.changeDimension(world, new ITeleporter(){

            public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                entity = repositionEntity.apply(false);
                entity.m_6021_(x, y, z);
                return entity;
            }
        });
    }

    private static void facePosition(Entity entity, double newX, double newY, double newZ, BlockPos dest) {
        double d0 = (double)dest.m_123341_() - newX;
        double d1 = (double)dest.m_123342_() - (newY + (double)entity.m_20192_());
        double d2 = (double)dest.m_123343_() - newZ;
        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
        float f1 = (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.29577951308232));
        entity.m_146926_(TeleportationTools.updateRotation(entity.m_146909_(), f1));
        entity.m_146922_(TeleportationTools.updateRotation(entity.m_146908_(), f));
    }

    private static float updateRotation(float angle, float targetAngle) {
        float f = Mth.m_14177_((float)(targetAngle - angle));
        return angle + f;
    }

    public static Entity teleportEntity(Entity entity, Level destWorld, final double newX, final double newY, final double newZ, final Direction facing) {
        Level world = entity.m_20193_();
        if (Objects.equals(world.m_46472_(), destWorld.m_46472_())) {
            if (facing != null) {
                TeleportationTools.fixOrientation(entity, newX, newY, newZ, facing);
            }
            entity.m_7678_(newX, newY, newZ, entity.m_146908_(), entity.m_146909_());
            ((ServerLevel)destWorld).m_8647_(entity);
            return entity;
        }
        return entity.changeDimension((ServerLevel)destWorld, new ITeleporter(){

            public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                entity = repositionEntity.apply(false);
                if (facing != null) {
                    TeleportationTools.fixOrientation(entity, newX, newY, newZ, facing);
                }
                entity.m_6021_(newX, newY, newZ);
                return entity;
            }
        });
    }

    private static void fixOrientation(Entity entity, double newX, double newY, double newZ, Direction facing) {
        if (facing != Direction.DOWN && facing != Direction.UP) {
            TeleportationTools.facePosition(entity, newX, newY, newZ, new BlockPos((int)newX, (int)newY, (int)newZ).m_5484_(facing, 4));
        }
    }
}

