/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.util;

import java.nio.ByteBuffer;
import java.util.PrimitiveIterator;

public final class StringUtil {
    public static final int MAX_PASTE_LENGTH = 512;

    private StringUtil() {
    }

    public static byte unicodeToTerminal(int chr) {
        if (chr == 0 || chr == 9 || chr == 10 || chr == 13 || chr >= 32 && chr <= 126 || chr >= 160 && chr <= 255) {
            return (byte)chr;
        }
        if (chr >= 129792 && chr <= 129811) {
            return (byte)(chr + -129663);
        }
        if (chr >= 129812 && chr <= 129821) {
            return (byte)(chr + -129662);
        }
        return StringUtil.unicodeToCraftOsFallback(chr);
    }

    private static byte unicodeToCraftOsFallback(int c) {
        return switch (c) {
            case 9786 -> 1;
            case 9787 -> 2;
            case 9829 -> 3;
            case 9830 -> 4;
            case 9827 -> 5;
            case 9824 -> 6;
            case 8226 -> 7;
            case 9688 -> 8;
            case 9794 -> 11;
            case 9792 -> 12;
            case 9834 -> 14;
            case 9835 -> 15;
            case 9658 -> 16;
            case 9668 -> 17;
            case 8597 -> 18;
            case 8252 -> 19;
            case 9644 -> 22;
            case 8616 -> 23;
            case 8593 -> 24;
            case 8595 -> 25;
            case 8594 -> 26;
            case 8592 -> 27;
            case 8735 -> 28;
            case 8596 -> 29;
            case 9650 -> 30;
            case 9660 -> 31;
            case 129945 -> 127;
            case 9612 -> -107;
            default -> 63;
        };
    }

    public static boolean isTypableChar(byte chr) {
        return chr != 0 && chr != 13 && chr != 10;
    }

    private static boolean isAllowedInLabel(char c) {
        return c >= ' ' && c <= '~' || c >= '\u00a1' && c <= '\u00ff' && c != '\u00a7';
    }

    public static String normaliseLabel(String text) {
        int length = Math.min(32, text.length());
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            builder.append(StringUtil.isAllowedInLabel(c) ? c : (char)'?');
        }
        return builder.toString();
    }

    public static ByteBuffer getClipboardString(String clipboard) {
        byte chr;
        byte[] output = new byte[Math.min(512, clipboard.length())];
        int idx = 0;
        PrimitiveIterator.OfInt iterator = clipboard.codePoints().iterator();
        while (iterator.hasNext() && idx <= output.length && StringUtil.isTypableChar(chr = StringUtil.unicodeToTerminal(iterator.next()))) {
            output[idx++] = chr;
        }
        return ByteBuffer.wrap(output, 0, idx).asReadOnlyBuffer();
    }
}

