/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.core.metrics.Metrics;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.command.CommandUtils;
import dan200.computercraft.shared.command.Exceptions;
import dan200.computercraft.shared.command.UserLevel;
import dan200.computercraft.shared.command.arguments.ComputerArgumentType;
import dan200.computercraft.shared.command.arguments.ComputerSelector;
import dan200.computercraft.shared.command.arguments.TrackingFieldArgumentType;
import dan200.computercraft.shared.command.builder.CommandBuilder;
import dan200.computercraft.shared.command.builder.HelpingArgumentBuilder;
import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.command.text.TableBuilder;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.inventory.AbstractComputerMenu;
import dan200.computercraft.shared.computer.inventory.ComputerMenuWithoutInventory;
import dan200.computercraft.shared.computer.metrics.basic.Aggregate;
import dan200.computercraft.shared.computer.metrics.basic.AggregatedMetric;
import dan200.computercraft.shared.computer.metrics.basic.BasicComputerMetricsObserver;
import dan200.computercraft.shared.computer.metrics.basic.ComputerMetrics;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.platform.PlatformHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public final class CommandComputerCraft {
    public static final UUID SYSTEM_UUID = new UUID(0L, 0L);
    public static final String CLIENT_OPEN_FOLDER = "computercraft-computer-folder";
    private static final List<AggregatedMetric> DEFAULT_FIELDS = List.of(new AggregatedMetric(Metrics.COMPUTER_TASKS, Aggregate.COUNT), new AggregatedMetric(Metrics.COMPUTER_TASKS, Aggregate.NONE), new AggregatedMetric(Metrics.COMPUTER_TASKS, Aggregate.AVG));

    private CommandComputerCraft() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)HelpingArgumentBuilder.choice("computercraft").then((ArgumentBuilder<CommandSourceStack, ?>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dump").requires(ModRegistry.Permissions.PERMISSION_DUMP)).executes(c -> CommandComputerCraft.dump((CommandSourceStack)c.getSource()))).then(CommandBuilder.args().arg("computer", ComputerArgumentType.get()).executes((Command<CommandSourceStack>)((Command)c -> CommandComputerCraft.dumpComputer((CommandSourceStack)c.getSource(), ComputerArgumentType.getOne((CommandContext<CommandSourceStack>)c, "computer")))))).then(CommandBuilder.command("shutdown").requires(ModRegistry.Permissions.PERMISSION_SHUTDOWN).argManyValue("computers", ComputerArgumentType.get(), ComputerSelector.all()).executes((c, a) -> CommandComputerCraft.shutdown((CommandSourceStack)c.getSource(), CommandComputerCraft.unwrap((CommandSourceStack)c.getSource(), a))))).then(CommandBuilder.command("turn-on").requires(ModRegistry.Permissions.PERMISSION_TURN_ON).argManyValue("computers", ComputerArgumentType.get(), ComputerSelector.all()).executes((c, a) -> CommandComputerCraft.turnOn((CommandSourceStack)c.getSource(), CommandComputerCraft.unwrap((CommandSourceStack)c.getSource(), a))))).then(CommandBuilder.command("tp").requires(ModRegistry.Permissions.PERMISSION_TP).arg("computer", ComputerArgumentType.get()).executes((Command<CommandSourceStack>)((Command)c -> CommandComputerCraft.teleport((CommandSourceStack)c.getSource(), ComputerArgumentType.getOne((CommandContext<CommandSourceStack>)c, "computer")))))).then(CommandBuilder.command("queue").requires(ModRegistry.Permissions.PERMISSION_QUEUE).arg((ArgumentBuilder<CommandSourceStack, ?>)RequiredArgumentBuilder.argument((String)"computer", (ArgumentType)ComputerArgumentType.get()).suggests((context, builder) -> Suggestions.empty())).argManyValue("args", StringArgumentType.string(), List.of()).executes((c, a) -> CommandComputerCraft.queue(ComputerArgumentType.getMany((CommandContext<CommandSourceStack>)c, "computer"), a)))).then(CommandBuilder.command("view").requires(ModRegistry.Permissions.PERMISSION_VIEW).arg("computer", ComputerArgumentType.get()).executes((Command<CommandSourceStack>)((Command)c -> CommandComputerCraft.view((CommandSourceStack)c.getSource(), ComputerArgumentType.getOne((CommandContext<CommandSourceStack>)c, "computer")))))).then(((LiteralArgumentBuilder)HelpingArgumentBuilder.choice("track").requires(ModRegistry.Permissions.PERMISSION_TRACK).then(CommandBuilder.command("start").executes((Command<CommandSourceStack>)((Command)c -> CommandComputerCraft.trackStart((CommandSourceStack)c.getSource())))).then(CommandBuilder.command("stop").executes((Command<CommandSourceStack>)((Command)c -> CommandComputerCraft.trackStop((CommandSourceStack)c.getSource()))))).then(CommandBuilder.command("dump").argManyValue("fields", TrackingFieldArgumentType.metric(), DEFAULT_FIELDS).executes((c, f) -> CommandComputerCraft.trackDump((CommandSourceStack)c.getSource(), f)))));
    }

    private static int dump(CommandSourceStack source) {
        TableBuilder table = new TableBuilder("DumpAll", "Computer", "On", "Position");
        ArrayList<ServerComputer> computers = new ArrayList<ServerComputer>(ServerContext.get(source.m_81377_()).registry().getComputers());
        ServerLevel world = source.m_81372_();
        BlockPos pos = BlockPos.m_274446_((Position)source.m_81371_());
        computers.sort((arg_0, arg_1) -> CommandComputerCraft.lambda$dump$11((Level)world, pos, arg_0, arg_1));
        for (ServerComputer computer : computers) {
            table.row(new Component[]{CommandComputerCraft.linkComputer(source, computer, computer.getID()), ChatHelpers.bool(computer.isOn()), CommandComputerCraft.linkPosition(source, computer)});
        }
        table.display(source);
        return computers.size();
    }

    private static int dumpComputer(CommandSourceStack source, ServerComputer computer) {
        TableBuilder table = new TableBuilder("Dump");
        table.row(new Component[]{ChatHelpers.header("Instance ID"), ChatHelpers.text(Integer.toString(computer.getInstanceID()))});
        table.row(new Component[]{ChatHelpers.header("Instance UUID"), ChatHelpers.text(computer.getInstanceUUID().toString())});
        table.row(new Component[]{ChatHelpers.header("Id"), ChatHelpers.text(Integer.toString(computer.getID()))});
        table.row(new Component[]{ChatHelpers.header("Label"), ChatHelpers.text(computer.getLabel())});
        table.row(new Component[]{ChatHelpers.header("On"), ChatHelpers.bool(computer.isOn())});
        table.row(new Component[]{ChatHelpers.header("Position"), CommandComputerCraft.linkPosition(source, computer)});
        table.row(new Component[]{ChatHelpers.header("Family"), ChatHelpers.text(computer.getFamily().toString())});
        for (ComputerSide side : ComputerSide.values()) {
            IPeripheral peripheral = computer.getPeripheral(side);
            if (peripheral == null) continue;
            table.row(new Component[]{ChatHelpers.header("Peripheral " + side.getName()), ChatHelpers.text(peripheral.getType())});
        }
        table.display(source);
        return 1;
    }

    private static int shutdown(CommandSourceStack source, Collection<ServerComputer> computers) {
        int shutdown = 0;
        for (ServerComputer computer : computers) {
            if (computer.isOn()) {
                ++shutdown;
            }
            computer.shutdown();
        }
        int didShutdown = shutdown;
        source.m_288197_(() -> Component.m_237110_((String)"commands.computercraft.shutdown.done", (Object[])new Object[]{didShutdown, computers.size()}), false);
        return shutdown;
    }

    private static int turnOn(CommandSourceStack source, Collection<ServerComputer> computers) {
        int on = 0;
        for (ServerComputer computer : computers) {
            if (!computer.isOn()) {
                ++on;
            }
            computer.turnOn();
        }
        int didOn = on;
        source.m_288197_(() -> Component.m_237110_((String)"commands.computercraft.turn_on.done", (Object[])new Object[]{didOn, computers.size()}), false);
        return on;
    }

    private static int teleport(CommandSourceStack source, ServerComputer computer) throws CommandSyntaxException {
        ServerLevel world = computer.getLevel();
        Vec3 pos = Vec3.m_82539_((Vec3i)computer.getPosition());
        source.m_81374_().m_264318_(world, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), EnumSet.noneOf(RelativeMovement.class), 0.0f, 0.0f);
        return 1;
    }

    private static int queue(Collection<ServerComputer> computers, List<String> args) {
        Object[] rest = args.toArray();
        int queued = 0;
        for (ServerComputer computer : computers) {
            if (computer.getFamily() != ComputerFamily.COMMAND || !computer.isOn()) continue;
            computer.queueEvent("computer_command", rest);
            ++queued;
        }
        return queued;
    }

    private static int view(CommandSourceStack source, ServerComputer computer) throws CommandSyntaxException {
        PlatformHelper.get().openMenu((Player)source.m_81375_(), (Component)Component.m_237115_((String)"gui.computercraft.view_computer"), (id, player, entity) -> new ComputerMenuWithoutInventory((MenuType<? extends AbstractComputerMenu>)((MenuType)ModRegistry.Menus.COMPUTER.get()), id, player, p -> true, computer), new ComputerContainerData(computer, ItemStack.f_41583_));
        return 1;
    }

    private static int trackStart(CommandSourceStack source) {
        CommandComputerCraft.getMetricsInstance(source).start();
        String stopCommand = "/computercraft track stop";
        source.m_288197_(() -> Component.m_237110_((String)"commands.computercraft.track.start.stop", (Object[])new Object[]{ChatHelpers.link(ChatHelpers.text(stopCommand), stopCommand, (Component)Component.m_237115_((String)"commands.computercraft.track.stop.action"))}), false);
        return 1;
    }

    private static int trackStop(CommandSourceStack source) throws CommandSyntaxException {
        BasicComputerMetricsObserver metrics = CommandComputerCraft.getMetricsInstance(source);
        if (!metrics.stop()) {
            throw Exceptions.NOT_TRACKING_EXCEPTION.create();
        }
        CommandComputerCraft.displayTimings(source, metrics.getSnapshot(), new AggregatedMetric(Metrics.COMPUTER_TASKS, Aggregate.AVG), DEFAULT_FIELDS);
        return 1;
    }

    private static int trackDump(CommandSourceStack source, List<AggregatedMetric> fields) throws CommandSyntaxException {
        AggregatedMetric sort;
        if (fields.size() == 1 && DEFAULT_FIELDS.contains(fields.get(0))) {
            sort = fields.get(0);
            fields = DEFAULT_FIELDS;
        } else {
            sort = fields.get(0);
        }
        return CommandComputerCraft.displayTimings(source, CommandComputerCraft.getMetricsInstance(source).getTimings(), sort, fields);
    }

    private static Component linkComputer(CommandSourceStack source, @Nullable ServerComputer computer, int computerId) {
        Component linkPath;
        MutableComponent out = Component.m_237113_((String)"");
        if (computer == null) {
            out.m_130946_("#" + computerId + " ").m_7220_((Component)ChatHelpers.coloured("(unloaded)", ChatFormatting.GRAY));
        } else {
            out.m_7220_(ChatHelpers.makeComputerDumpCommand(computer));
        }
        if (computer != null && CommandUtils.isPlayer(source)) {
            if (ModRegistry.Permissions.PERMISSION_TP.test(source)) {
                out.m_130946_(" ").m_7220_(ChatHelpers.link(ChatHelpers.text("\u261b"), ChatHelpers.makeComputerCommand("tp", computer), (Component)Component.m_237115_((String)"commands.computercraft.tp.action")));
            }
            if (ModRegistry.Permissions.PERMISSION_VIEW.test(source)) {
                out.m_130946_(" ").m_7220_(ChatHelpers.link(ChatHelpers.text("\u20e2"), ChatHelpers.makeComputerCommand("view", computer), (Component)Component.m_237115_((String)"commands.computercraft.view.action")));
            }
        }
        if (CommandUtils.isPlayer(source) && UserLevel.isOwner(source) && (linkPath = CommandComputerCraft.linkStorage(source, computerId)) != null) {
            out.m_130946_(" ").m_7220_(linkPath);
        }
        return out;
    }

    private static Component linkPosition(CommandSourceStack context, ServerComputer computer) {
        if (ModRegistry.Permissions.PERMISSION_TP.test(context)) {
            return ChatHelpers.link(ChatHelpers.position(computer.getPosition()), ChatHelpers.makeComputerCommand("tp", computer), (Component)Component.m_237115_((String)"commands.computercraft.tp.action"));
        }
        return ChatHelpers.position(computer.getPosition());
    }

    @Nullable
    private static Component linkStorage(CommandSourceStack source, int id) {
        File file = new File(ServerContext.get(source.m_81377_()).storageDir().toFile(), "computer/" + id);
        if (!file.isDirectory()) {
            return null;
        }
        return ChatHelpers.clientLink(ChatHelpers.text("\u270e"), "/computercraft-computer-folder " + id, (Component)Component.m_237115_((String)"commands.computercraft.dump.open_path"));
    }

    private static BasicComputerMetricsObserver getMetricsInstance(CommandSourceStack source) {
        Entity entity = source.m_81373_();
        return ServerContext.get(source.m_81377_()).metrics().getMetricsInstance(entity instanceof Player ? entity.m_20148_() : SYSTEM_UUID);
    }

    private static int displayTimings(CommandSourceStack source, List<ComputerMetrics> timings, AggregatedMetric sortField, List<AggregatedMetric> fields) throws CommandSyntaxException {
        if (timings.isEmpty()) {
            throw Exceptions.NO_TIMINGS_EXCEPTION.create();
        }
        timings.sort(Comparator.comparing(x -> x.get(sortField.metric(), sortField.aggregate())).reversed());
        Component[] headers = new Component[1 + fields.size()];
        headers[0] = Component.m_237115_((String)"commands.computercraft.track.dump.computer");
        for (int i = 0; i < fields.size(); ++i) {
            headers[i + 1] = fields.get(i).displayName();
        }
        TableBuilder table = new TableBuilder("Metrics", headers);
        for (ComputerMetrics entry : timings) {
            ServerComputer serverComputer = entry.computer();
            Component computerComponent = CommandComputerCraft.linkComputer(source, serverComputer, entry.computerId());
            Component[] row = new Component[1 + fields.size()];
            row[0] = computerComponent;
            for (int i = 0; i < fields.size(); ++i) {
                AggregatedMetric metric = fields.get(i);
                row[i + 1] = ChatHelpers.text(entry.getFormatted(metric.metric(), metric.aggregate()));
            }
            table.row(row);
        }
        table.display(source);
        return timings.size();
    }

    public static Set<ServerComputer> unwrap(CommandSourceStack source, Collection<ComputerSelector> suppliers) {
        HashSet<ServerComputer> computers = new HashSet<ServerComputer>();
        for (ComputerSelector supplier : suppliers) {
            supplier.find(source).forEach(computers::add);
        }
        return computers;
    }

    private static /* synthetic */ int lambda$dump$11(Level world, BlockPos pos, ServerComputer a, ServerComputer b) {
        if (a.getLevel() == b.getLevel() && a.getLevel() == world) {
            return Double.compare(a.getPosition().m_123331_((Vec3i)pos), b.getPosition().m_123331_((Vec3i)pos));
        }
        if (a.getLevel() == world) {
            return -1;
        }
        if (b.getLevel() == world) {
            return 1;
        }
        return a.getInstanceUUID().compareTo(b.getInstanceUUID());
    }
}

