/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.config;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import dan200.computercraft.core.CoreConfig;
import dan200.computercraft.core.Logging;
import dan200.computercraft.core.apis.http.NetworkUtils;
import dan200.computercraft.core.apis.http.options.ProxyType;
import dan200.computercraft.core.computer.mainthread.MainThreadConfig;
import dan200.computercraft.shared.config.AddressRuleConfig;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.config.ConfigFile;
import dan200.computercraft.shared.config.ProxyPasswordConfig;
import dan200.computercraft.shared.peripheral.monitor.MonitorRenderer;
import dan200.computercraft.shared.platform.PlatformHelper;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.filter.MarkerFilter;

public final class ConfigSpec {
    private static final int MODEM_MAX_RANGE = 100000;
    public static final ConfigFile serverSpec;
    public static final ConfigFile.Value<Integer> computerSpaceLimit;
    public static final ConfigFile.Value<Integer> floppySpaceLimit;
    public static final ConfigFile.Value<Integer> maximumFilesOpen;
    public static final ConfigFile.Value<String> defaultComputerSettings;
    public static final ConfigFile.Value<Boolean> logComputerErrors;
    public static final ConfigFile.Value<Boolean> commandRequireCreative;
    public static final ConfigFile.Value<Integer> uploadMaxSize;
    public static final ConfigFile.Value<List<? extends String>> disabledGenericMethods;
    public static final ConfigFile.Value<Integer> computerThreads;
    public static final ConfigFile.Value<Integer> maxMainGlobalTime;
    public static final ConfigFile.Value<Integer> maxMainComputerTime;
    public static final ConfigFile.Value<Boolean> httpEnabled;
    public static final ConfigFile.Value<Boolean> httpWebsocketEnabled;
    public static final ConfigFile.Value<List<? extends UnmodifiableConfig>> httpRules;
    public static final ConfigFile.Value<Integer> httpMaxRequests;
    public static final ConfigFile.Value<Integer> httpMaxWebsockets;
    public static final ConfigFile.Value<Integer> httpDownloadBandwidth;
    public static final ConfigFile.Value<Integer> httpUploadBandwidth;
    public static final ConfigFile.Value<ProxyType> httpProxyType;
    public static final ConfigFile.Value<String> httpProxyHost;
    public static final ConfigFile.Value<Integer> httpProxyPort;
    public static final ConfigFile.Value<Boolean> commandBlockEnabled;
    public static final ConfigFile.Value<Integer> modemRange;
    public static final ConfigFile.Value<Integer> modemHighAltitudeRange;
    public static final ConfigFile.Value<Integer> modemRangeDuringStorm;
    public static final ConfigFile.Value<Integer> modemHighAltitudeRangeDuringStorm;
    public static final ConfigFile.Value<Integer> maxNotesPerTick;
    public static final ConfigFile.Value<Integer> monitorBandwidth;
    public static final ConfigFile.Value<Boolean> turtlesNeedFuel;
    public static final ConfigFile.Value<Integer> turtleFuelLimit;
    public static final ConfigFile.Value<Integer> advancedTurtleFuelLimit;
    public static final ConfigFile.Value<Boolean> turtlesCanPush;
    public static final ConfigFile.Value<Integer> computerTermWidth;
    public static final ConfigFile.Value<Integer> computerTermHeight;
    public static final ConfigFile.Value<Integer> pocketTermWidth;
    public static final ConfigFile.Value<Integer> pocketTermHeight;
    public static final ConfigFile.Value<Integer> monitorWidth;
    public static final ConfigFile.Value<Integer> monitorHeight;
    public static final ConfigFile clientSpec;
    public static final ConfigFile.Value<MonitorRenderer> monitorRenderer;
    public static final ConfigFile.Value<Integer> monitorDistance;
    public static final ConfigFile.Value<Integer> uploadNagDelay;
    private static MarkerFilter logFilter;

    private ConfigSpec() {
    }

    public static void syncServer(@Nullable Path path) {
        org.apache.logging.log4j.spi.LoggerContext loggerContext;
        Config.computerSpaceLimit = (Integer)computerSpaceLimit.get();
        Config.floppySpaceLimit = (Integer)floppySpaceLimit.get();
        Config.uploadMaxSize = (Integer)uploadMaxSize.get();
        CoreConfig.maximumFilesOpen = (Integer)maximumFilesOpen.get();
        CoreConfig.defaultComputerSettings = (String)defaultComputerSettings.get();
        Config.commandRequireCreative = (Boolean)commandRequireCreative.get();
        MarkerFilter logFilter = MarkerFilter.createFilter((String)Logging.COMPUTER_ERROR.getName(), (Filter.Result)((Boolean)logComputerErrors.get() != false ? Filter.Result.ACCEPT : Filter.Result.DENY), (Filter.Result)Filter.Result.NEUTRAL);
        if (!logFilter.equals(ConfigSpec.logFilter) && (loggerContext = LogManager.getContext((boolean)false)) instanceof LoggerContext) {
            LoggerContext context = (LoggerContext)loggerContext;
            context.removeFilter((Filter)ConfigSpec.logFilter);
            ConfigSpec.logFilter = logFilter;
            context.addFilter((Filter)ConfigSpec.logFilter);
        }
        CoreConfig.httpEnabled = (Boolean)httpEnabled.get();
        CoreConfig.httpWebsocketEnabled = (Boolean)httpWebsocketEnabled.get();
        CoreConfig.httpRules = ((List)httpRules.get()).stream().map(AddressRuleConfig::parseRule).toList();
        CoreConfig.httpMaxRequests = (Integer)httpMaxRequests.get();
        CoreConfig.httpMaxWebsockets = (Integer)httpMaxWebsockets.get();
        CoreConfig.httpDownloadBandwidth = (Integer)httpDownloadBandwidth.get();
        CoreConfig.httpUploadBandwidth = (Integer)httpUploadBandwidth.get();
        CoreConfig.httpProxyType = (ProxyType)((Object)httpProxyType.get());
        CoreConfig.httpProxyHost = (String)httpProxyHost.get();
        CoreConfig.httpProxyPort = (Integer)httpProxyPort.get();
        if (path != null) {
            ProxyPasswordConfig.init(path.resolveSibling("computercraft-proxy.pw"));
        }
        NetworkUtils.reloadConfig();
        Config.enableCommandBlock = (Boolean)commandBlockEnabled.get();
        Config.maxNotesPerTick = (Integer)maxNotesPerTick.get();
        Config.modemRange = (Integer)modemRange.get();
        Config.modemHighAltitudeRange = (Integer)modemHighAltitudeRange.get();
        Config.modemRangeDuringStorm = (Integer)modemRangeDuringStorm.get();
        Config.modemHighAltitudeRangeDuringStorm = (Integer)modemHighAltitudeRangeDuringStorm.get();
        Config.monitorBandwidth = ((Integer)monitorBandwidth.get()).intValue();
        Config.turtlesNeedFuel = (Boolean)turtlesNeedFuel.get();
        Config.turtleFuelLimit = (Integer)turtleFuelLimit.get();
        Config.advancedTurtleFuelLimit = (Integer)advancedTurtleFuelLimit.get();
        Config.turtlesCanPush = (Boolean)turtlesCanPush.get();
        Config.monitorWidth = (Integer)monitorWidth.get();
        Config.monitorHeight = (Integer)monitorHeight.get();
    }

    public static void syncClient(@Nullable Path path) {
        Config.monitorRenderer = (MonitorRenderer)((Object)monitorRenderer.get());
        Config.monitorDistance = (Integer)monitorDistance.get();
        Config.uploadNagDelay = (Integer)uploadNagDelay.get();
    }

    static {
        logFilter = MarkerFilter.createFilter((String)Logging.COMPUTER_ERROR.getName(), (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.NEUTRAL);
        org.apache.logging.log4j.spi.LoggerContext loggerContext = LogManager.getContext((boolean)false);
        if (loggerContext instanceof LoggerContext) {
            LoggerContext context = (LoggerContext)loggerContext;
            context.addFilter((Filter)logFilter);
        }
        ConfigFile.Builder builder = PlatformHelper.get().createConfigBuilder();
        computerSpaceLimit = builder.comment("The disk space limit for computers and turtles, in bytes.").define("computer_space_limit", Config.computerSpaceLimit);
        floppySpaceLimit = builder.comment("The disk space limit for floppy disks, in bytes.").define("floppy_space_limit", Config.floppySpaceLimit);
        uploadMaxSize = builder.comment("The file upload size limit, in bytes. Must be in range of 1 KiB and 16 MiB.\nKeep in mind that uploads are processed in a single tick - large files or\npoor network performance can stall the networking thread. And mind the disk space!").defineInRange("upload_max_size", Config.uploadMaxSize, 1024, 0x1000000);
        maximumFilesOpen = builder.comment("Set how many files a computer can have open at the same time. Set to 0 for unlimited.").defineInRange("maximum_open_files", CoreConfig.maximumFilesOpen, 0, Integer.MAX_VALUE);
        defaultComputerSettings = builder.comment("A comma separated list of default system settings to set on new computers.\nExample: \"shell.autocomplete=false,lua.autocomplete=false,edit.autocomplete=false\"\nwill disable all autocompletion.").define("default_computer_settings", CoreConfig.defaultComputerSettings);
        logComputerErrors = builder.comment("Log exceptions thrown by peripherals and other Lua objects. This makes it easier\nfor mod authors to debug problems, but may result in log spam should people use\nbuggy methods.").define("log_computer_errors", true);
        commandRequireCreative = builder.comment("Require players to be in creative mode and be opped in order to interact with\ncommand computers. This is the default behaviour for vanilla's Command blocks.").define("command_require_creative", Config.commandRequireCreative);
        disabledGenericMethods = builder.comment("A list of generic methods or method sources to disable. Generic methods are\nmethods added to a block/block entity when there is no explicit peripheral\nprovider. This includes inventory methods (i.e. inventory.getItemDetail,\ninventory.pushItems), and (if on Forge), the fluid_storage and energy_storage\nmethods.\nMethods in this list can either be a whole group of methods (computercraft:inventory)\nor a single method (computercraft:inventory#pushItems).\n").worldRestart().defineList("disabled_generic_methods", List.of(), x -> x instanceof String);
        builder.comment("Controls execution behaviour of computers. This is largely intended for\nfine-tuning servers, and generally shouldn't need to be touched.");
        builder.push("execution");
        computerThreads = builder.comment("Set the number of threads computers can run on. A higher number means more\ncomputers can run at once, but may induce lag. Please note that some mods may\nnot work with a thread count higher than 1. Use with caution.").worldRestart().defineInRange("computer_threads", 1, 1, Integer.MAX_VALUE);
        maxMainGlobalTime = builder.comment("The maximum time that can be spent executing tasks in a single tick, in\nmilliseconds.\nNote, we will quite possibly go over this limit, as there's no way to tell how\nlong a will take - this aims to be the upper bound of the average time.").defineInRange("max_main_global_time", (int)TimeUnit.NANOSECONDS.toMillis(MainThreadConfig.DEFAULT_MAX_GLOBAL_TIME), 1, Integer.MAX_VALUE);
        maxMainComputerTime = builder.comment("The ideal maximum time a computer can execute for in a tick, in milliseconds.\nNote, we will quite possibly go over this limit, as there's no way to tell how\nlong a will take - this aims to be the upper bound of the average time.").defineInRange("max_main_computer_time", (int)TimeUnit.NANOSECONDS.toMillis(MainThreadConfig.DEFAULT_MAX_COMPUTER_TIME), 1, Integer.MAX_VALUE);
        builder.pop();
        builder.comment("Controls the HTTP API");
        builder.push("http");
        httpEnabled = builder.comment("Enable the \"http\" API on Computers. Disabling this also disables the \"pastebin\" and\n\"wget\" programs, that many users rely on. It's recommended to leave this on and use\nthe \"rules\" config option to impose more fine-grained control.").define("enabled", CoreConfig.httpEnabled);
        httpWebsocketEnabled = builder.comment("Enable use of http websockets. This requires the \"http_enable\" option to also be true.").define("websocket_enabled", CoreConfig.httpWebsocketEnabled);
        httpRules = builder.comment("A list of rules which control behaviour of the \"http\" API for specific domains or\nIPs. Each rule matches against a hostname and an optional port, and then sets several\nproperties for the request.  Rules are evaluated in order, meaning earlier rules override\nlater ones.\n\nValid properties:\n - \"host\" (required): The domain or IP address this rule matches. This may be a domain name\n   (\"pastebin.com\"), wildcard (\"*.pastebin.com\") or CIDR notation (\"127.0.0.0/8\").\n - \"port\" (optional): Only match requests for a specific port, such as 80 or 443.\n\n - \"action\" (optional): Whether to allow or deny this request.\n - \"max_download\" (optional): The maximum size (in bytes) that a computer can download in this\n   request.\n - \"max_upload\" (optional): The maximum size (in bytes) that a computer can upload in a this request.\n - \"max_websocket_message\" (optional): The maximum size (in bytes) that a computer can send or\n   receive in one websocket packet.\n - \"use_proxy\" (optional): Enable use of the HTTP/SOCKS proxy if it is configured.").defineList("rules", AddressRuleConfig.defaultRules(), x -> x instanceof UnmodifiableConfig);
        httpMaxRequests = builder.comment("The number of http requests a computer can make at one time. Additional requests\nwill be queued, and sent when the running requests have finished. Set to 0 for\nunlimited.").defineInRange("max_requests", CoreConfig.httpMaxRequests, 0, Integer.MAX_VALUE);
        httpMaxWebsockets = builder.comment("The number of websockets a computer can have open at one time.").defineInRange("max_websockets", CoreConfig.httpMaxWebsockets, 1, Integer.MAX_VALUE);
        builder.comment("Limits bandwidth used by computers.").push("bandwidth");
        httpDownloadBandwidth = builder.comment("The number of bytes which can be downloaded in a second. This is shared across all computers. (bytes/s).").defineInRange("global_download", CoreConfig.httpDownloadBandwidth, 1, Integer.MAX_VALUE);
        httpUploadBandwidth = builder.comment("The number of bytes which can be uploaded in a second. This is shared across all computers. (bytes/s).").defineInRange("global_upload", CoreConfig.httpUploadBandwidth, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.comment("Tunnels HTTP and websocket requests through a proxy server. Only affects HTTP\nrules with \"use_proxy\" set to true (off by default).\nIf authentication is required for the proxy, create a \"computercraft-proxy.pw\"\nfile in the same directory as \"computercraft-server.toml\", containing the\nusername and password separated by a colon, e.g. \"myuser:mypassword\". For\nSOCKS4 proxies only the username is required.").push("proxy");
        httpProxyType = builder.comment("The type of proxy to use.").defineEnum("type", CoreConfig.httpProxyType);
        httpProxyHost = builder.comment("The hostname or IP address of the proxy server.").define("host", CoreConfig.httpProxyHost);
        httpProxyPort = builder.comment("The port of the proxy server.").defineInRange("port", CoreConfig.httpProxyPort, 1, 65536);
        builder.pop();
        builder.pop();
        builder.comment("Various options relating to peripherals.");
        builder.push("peripheral");
        commandBlockEnabled = builder.comment("Enable Command Block peripheral support").define("command_block_enabled", Config.enableCommandBlock);
        modemRange = builder.comment("The range of Wireless Modems at low altitude in clear weather, in meters.").defineInRange("modem_range", Config.modemRange, 0, 100000);
        modemHighAltitudeRange = builder.comment("The range of Wireless Modems at maximum altitude in clear weather, in meters.").defineInRange("modem_high_altitude_range", Config.modemHighAltitudeRange, 0, 100000);
        modemRangeDuringStorm = builder.comment("The range of Wireless Modems at low altitude in stormy weather, in meters.").defineInRange("modem_range_during_storm", Config.modemRangeDuringStorm, 0, 100000);
        modemHighAltitudeRangeDuringStorm = builder.comment("The range of Wireless Modems at maximum altitude in stormy weather, in meters.").defineInRange("modem_high_altitude_range_during_storm", Config.modemHighAltitudeRangeDuringStorm, 0, 100000);
        maxNotesPerTick = builder.comment("Maximum amount of notes a speaker can play at once.").defineInRange("max_notes_per_tick", Config.maxNotesPerTick, 1, Integer.MAX_VALUE);
        monitorBandwidth = builder.comment("The limit to how much monitor data can be sent *per tick*. Note:\n - Bandwidth is measured before compression, so the data sent to the client is\n   smaller.\n - This ignores the number of players a packet is sent to. Updating a monitor for\n   one player consumes the same bandwidth limit as sending to 20.\n - A full sized monitor sends ~25kb of data. So the default (1MB) allows for ~40\n   monitors to be updated in a single tick.\nSet to 0 to disable.").defineInRange("monitor_bandwidth", (int)Config.monitorBandwidth, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.comment("Various options relating to turtles.");
        builder.push("turtle");
        turtlesNeedFuel = builder.comment("Set whether Turtles require fuel to move.").define("need_fuel", Config.turtlesNeedFuel);
        turtleFuelLimit = builder.comment("The fuel limit for Turtles.").defineInRange("normal_fuel_limit", Config.turtleFuelLimit, 0, Integer.MAX_VALUE);
        advancedTurtleFuelLimit = builder.comment("The fuel limit for Advanced Turtles.").defineInRange("advanced_fuel_limit", Config.advancedTurtleFuelLimit, 0, Integer.MAX_VALUE);
        turtlesCanPush = builder.comment("If set to true, Turtles will push entities out of the way instead of stopping if\nthere is space to do so.").define("can_push", Config.turtlesCanPush);
        builder.pop();
        builder.comment("Configure the size of various computer's terminals.\nLarger terminals require more bandwidth, so use with care.").push("term_sizes");
        builder.comment("Terminal size of computers.").push("computer");
        computerTermWidth = builder.comment("Width of computer terminal").defineInRange("width", 51, 1, 255);
        computerTermHeight = builder.comment("Height of computer terminal").defineInRange("height", 19, 1, 255);
        builder.pop();
        builder.comment("Terminal size of pocket computers.").push("pocket_computer");
        pocketTermWidth = builder.comment("Width of pocket computer terminal").defineInRange("width", 26, 1, 255);
        pocketTermHeight = builder.comment("Height of pocket computer terminal").defineInRange("height", 20, 1, 255);
        builder.pop();
        builder.comment("Maximum size of monitors (in blocks).").push("monitor");
        monitorWidth = builder.comment("Maximum width of monitors").defineInRange("width", Config.monitorWidth, 1, 32);
        monitorHeight = builder.comment("Maximum height of monitors").defineInRange("height", Config.monitorHeight, 1, 32);
        builder.pop();
        builder.pop();
        serverSpec = builder.build(ConfigSpec::syncServer);
        ConfigFile.Builder clientBuilder = PlatformHelper.get().createConfigBuilder();
        monitorRenderer = clientBuilder.comment("The renderer to use for monitors. Generally this should be kept at \"best\" - if\nmonitors have performance issues, you may wish to experiment with alternative\nrenderers.").defineEnum("monitor_renderer", MonitorRenderer.BEST);
        monitorDistance = clientBuilder.comment("The maximum distance monitors will render at. This defaults to the standard tile\nentity limit, but may be extended if you wish to build larger monitors.").defineInRange("monitor_distance", 64, 16, 1024);
        uploadNagDelay = clientBuilder.comment("The delay in seconds after which we'll notify about unhandled imports. Set to 0 to disable.").defineInRange("upload_nag_delay", Config.uploadNagDelay, 0, 60);
        clientSpec = clientBuilder.build(ConfigSpec::syncClient);
    }
}

